<?php
header('Content-Type: application/json');
include '../db.php'; // Include your database connection file

// Retrieve JSON input
$data = json_decode(file_get_contents('php://input'), true);

// Extract and sanitize the data
$user_id = isset($data['user_id']) ? intval($data['user_id']) : '';
$latitude = isset($data['latitude']) ? floatval($data['latitude']) : '';
$longitude = isset($data['longitude']) ? floatval($data['longitude']) : '';

// Validate input
if (empty($user_id) || empty($latitude) || empty($longitude)) {
    echo json_encode(['success' => false, 'message' => 'All fields are required']);
    exit;
}

// Update the location in the database
$sql = "UPDATE registered_vehicles SET vehicle_current_lat = ?, vehicle_current_lng = ? WHERE id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param('ssi', $latitude, $longitude, $user_id);

if ($stmt->execute()) {
    echo json_encode(['success' => true]);
} else {
    echo json_encode(['success' => false, 'message' => 'Failed to update location']);
}

$stmt->close();
$conn->close();
?>
