<?php
header('Content-Type: application/json');

include '../db.php';

$input = file_get_contents("php://input");
$data = json_decode($input, true);

$driver_id = $data['driver_id'];
$amount = $data['amount'];
$date = date("Y-m-d H:i:s", time());

$sql = "INSERT INTO withdrawal_requests (driver_id, amount, request_date) VALUES (?, ?, ?)";

$stmt = $conn->prepare($sql);
$stmt->bind_param("ids", $driver_id, $amount, $date);

$response = [];

if ($stmt->execute()) {
    $response['success'] = true;
} else {
    $response['success'] = false;
    $response['error'] = $stmt->error;
}

$stmt->close();
$conn->close();

echo json_encode($response);
?>
