<?php
header('Content-Type: application/json');
include '../db.php'; // Include your database connection file

$phone = $_GET['phone'] ?? '';
$password = $_GET['password'] ?? '';

if (empty($phone) || empty($password)) {
    echo json_encode(['success' => false, 'message' => 'Phone and password are required']);
    exit;
}

$sql = "SELECT * FROM registered_vehicles WHERE phone = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param('s', $phone);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    $user = $result->fetch_assoc();
    if (password_verify($password, $user['password'])) {
        if ($user['approval'] === '1') {
            // User is approved
            echo json_encode([
                'success' => true, 
                'user_id' => $user['id'], 
                'user_name' => $user['driver_name'],
                'vehicle_type' => $user['vehicle_type']
            ]);
        } else {
            // User's application is still under review
            echo json_encode(['success' => false, 'message' => 'Your application is under review']);
        }
    } else {
        echo json_encode(['success' => false, 'message' => 'Invalid phone or password']);
    }
} else {
    echo json_encode(['success' => false, 'message' => 'Invalid credentials']);
}

$conn->close();

?>
