<?php
include 'db.php';  // Include your database connection file

header('Content-Type: application/json');

// Get the JSON input data
$data = json_decode(file_get_contents('php://input'), true);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $booking_id = isset($data['booking_id']) ? $data['booking_id'] : null;

    // Check if the booking ID is provided
    if (!$booking_id) {
        echo json_encode(['success' => false, 'message' => 'Booking ID is required']);
        exit();
    }

    // Prepare the SQL statement to update the booking status
    $stmt = $conn->prepare("UPDATE new_trip_booking SET status = 'cancelled' WHERE id = ?");

    if (!$stmt) {
        echo json_encode(['success' => false, 'message' => 'Error in prepare statement: ' . $conn->error]);
        exit();
    }

    // Bind the booking ID to the SQL statement
    $stmt->bind_param('i', $booking_id);

    // Execute the statement and check if it was successful
    if ($stmt->execute()) {
        echo json_encode(['success' => true, 'message' => 'Booking cancelled successfully']);
    } else {
        echo json_encode(['success' => false, 'message' => 'Failed to cancel booking']);
    }

    // Close the statement
    $stmt->close();
} else {
    echo json_encode(['success' => false, 'message' => 'Invalid request method']);
}

// Close the database connection
$conn->close();
?>
