<?php
require_once 'db.php'; // Include your database connection file

header('Access-Control-Allow-Origin: *');
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");
header("Access-Control-Allow-Credentials: true");

$method = $_SERVER['REQUEST_METHOD'];
$response = array();

try {
    switch ($method) {
        case 'GET':
            // Fetch all registered users
            $result = $conn->query("SELECT * FROM users order by id DESC");
            $users = [];
            while ($row = $result->fetch_assoc()) {
                $users[] = $row;
            }
            $response = $users;
            break;

        case 'POST':
            // Add a new registered user
            $data = json_decode(file_get_contents("php://input"), true);
            $stmt = $conn->prepare("INSERT INTO users (name, phone, email, location, address, password, profile_picture, referral_code, refered_code, otp) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            $stmt->bind_param("ssssssssss", $data['name'], $data['phone'], $data['email'], $data['location'], $data['address'], $data['password'], $data['profile_picture'], $data['referral_code'], $data['refered_code'], $data['otp']);
            if ($stmt->execute()) {
                $response['message'] = 'User added successfully';
            } else {
                $response['error'] = 'Failed to add user';
            }
            break;

        case 'PUT':
            // Update an existing registered user
            $data = json_decode(file_get_contents("php://input"), true);
            $stmt = $conn->prepare("UPDATE users SET name = ?, phone = ?, email = ?, location = ?, address = ?, password = ?, profile_picture = ?, referral_code = ?, refered_code = ?, otp = ? WHERE id = ?");
            $stmt->bind_param("ssssssssssi", $data['name'], $data['phone'], $data['email'], $data['location'], $data['address'], $data['password'], $data['profile_picture'], $data['referral_code'], $data['refered_code'], $data['otp'], $data['id']);
            if ($stmt->execute()) {
                $response['message'] = 'User updated successfully';
            } else {
                $response['error'] = 'Failed to update user';
            }
            break;

        case 'DELETE':
            // Delete a registered user
            $id = $_GET['id'];
            $stmt = $conn->prepare("DELETE FROM users WHERE id = ?");
            $stmt->bind_param("i", $id);
            if ($stmt->execute()) {
                $response['message'] = 'User deleted successfully';
            } else {
                $response['error'] = 'Failed to delete user';
            }
            break;

        default:
            http_response_code(405); // Method Not Allowed
            $response['error'] = 'Method not allowed';
            break;
    }
} catch (Exception $e) {
    http_response_code(500); // Internal Server Error
    $response['error'] = $e->getMessage();
}

echo json_encode($response);
$conn->close();
?>
