<?php
require_once 'db.php'; // Include database connection

header('Access-Control-Allow-Origin: *');
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: GET");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

$response = array();

try {
    if ($_SERVER['REQUEST_METHOD'] === 'GET') {
        // Fetch all bookings with status 'Pending'
        $stmt = $conn->prepare("SELECT * FROM new_trip_booking WHERE status = 'pending'");
        $stmt->execute();
        $result = $stmt->get_result();

        $bookings = array();
        while ($row = $result->fetch_assoc()) {
            $bookings[] = $row;
        }

        $response = $bookings;
    } else {
        http_response_code(405); // Method Not Allowed
        $response['error'] = 'Method not allowed';
    }
} catch (Exception $e) {
    http_response_code(500); // Internal Server Error
    $response['error'] = $e->getMessage();
}

echo json_encode($response);
$conn->close();
?>
