<?php
session_start();
include 'db_connection.php'; // Corrected to 'db_config.php' to match earlier configuration
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
$error = '';
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $email = $_POST['email'];
    $password = $_POST['password'];

    // Basic method to execute SQL query
    $query = "SELECT * FROM registered_vehicles WHERE phone = '$email'";
    $result = mysqli_query($conn, $query);
    $user = mysqli_fetch_assoc($result);

    if ($user && password_verify($password, $user['password'])) {
        $_SESSION['driver_id'] = $user['id'];
        header("Location: index.php");
    } else {
        $error = "Invalid email or password";
    }
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Login</title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/materialize/1.0.0/css/materialize.min.css" rel="stylesheet">
    <style>
        body, html {
            height: 100%;
            margin: 0;
            display: flex;
            justify-content: center;
            align-items: center;
        }
        .container {
            width: 300px;
        }
    </style>
</head>
<body>
    <div class="container">
        <h3 class="center-align">Driver Login</h3>
        <?php if ($error): ?>
            <div class="card-panel red lighten-2">
                <span class="white-text"><?php echo $error; ?></span>
            </div>
        <?php endif; ?>
        <form method="POST">
            <div class="input-field">
                <input type="text" name="email" id="email" required>
                <label for="email">Phone</label>
            </div>
            <div class="input-field">
                <input type="password" name="password" id="password" required>
                <label for="password">Password</label>
            </div>
            <button type="submit" class="btn waves-effect waves-light">Login</button>
        </form>
        <p class="center-align">
            Don't have an account? <a href="#">Please register</a>
        </p>
    </div>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/materialize/1.0.0/js/materialize.min.js"></script>
</body>
</html>
