<?php
session_start();
if (!isset($_SESSION['driver_id'])) {
    header("Location: login.php");
    exit;
}

include 'db_connection.php';
$driver_id = $_SESSION['driver_id'];
$query = "SELECT * FROM registered_vehicles WHERE id = $driver_id";
$result = mysqli_query($conn, $query);
$user = mysqli_fetch_assoc($result);

$defaultProfilePicture = 'pro.png'; // Set the path to your default user icon
$profilePicture = $user['profile_picture'] ? htmlspecialchars($user['profile_picture']) : $defaultProfilePicture;

function displayFileInput($filePath, $inputName, $label) {
    if (!empty($filePath)) {
        echo '<div class="form-group">';
        echo '<label for="'.$inputName.'">'.$label.'</label>';
        echo '<input type="file" class="form-control-file" name="'.$inputName.'" id="'.$inputName.'" disabled>';
        echo '<span class="text-success">✔️</span>';
        echo '</div>';
    } else {
        echo '<div class="form-group">';
        echo '<label for="'.$inputName.'">'.$label.'</label>';
        echo '<input type="file" class="form-control-file" name="'.$inputName.'" id="'.$inputName.'">';
        echo '</div>';
    }
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Driver Dashboard</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background: #f4f7f6;
            display: flex;
            flex-direction: column;
            min-height: 100vh;
        }
        .navbar {
            background: #424242;
        }
        .navbar-brand {
            font-size: 1.5rem;
        }
        .container {
            flex: 1;
            margin-top: 20px;
        }
        .profile-card {
            margin-top: 20px;
        }
        .card {
            padding: 20px;
            border-radius: 10px;
        }
        .btn {
            border-radius: 20px;
        }
        .footer {
            background: #424242;
            padding: 10px 0;
        }
        .footer .container {
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
    </style>
</head>
<body>
    <!-- Navigation -->
    <nav class="navbar navbar-expand-lg navbar-dark">
        <a class="navbar-brand" href="#">Driver Dashboard</a>
        <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="navbarNav">
            <ul class="navbar-nav ml-auto">
                <li class="nav-item"><a class="nav-link" href="#!">Home</a></li>
                <li class="nav-item"><a class="nav-link" href="logout.php">Logout</a></li>
            </ul>
        </div>
    </nav>

    <div class="container">
        <h4>Driver Dashboard</h4>
        <div class="row">
            <div class="col-12 col-md-4">
                <div class="card profile-card bg-white">
                    <div class="text-center">
                        <img src="<?php echo $profilePicture; ?>" alt="profile picture" class="rounded-circle img-fluid" style="width: 150px; height: 150px;">
                        <h5><?php echo htmlspecialchars($user['driver_name']); ?></h5>
                        <p>Phone: <?php echo htmlspecialchars($user['phone']); ?><br>Email: <?php echo htmlspecialchars($user['driver_email']); ?></p>
                        <form method="POST" action="update_profile.php" enctype="multipart/form-data">
                            <div class="form-group">
                                <label for="profile_picture">Update Picture</label>
                                <input type="file" class="form-control-file" name="profile_picture" id="profile_picture">
                            </div>
                    </div>
                </div>
            </div>
            <div class="col-12 col-md-8">
                <div class="card bg-white">
                    <h5>My Profile</h5>
                    <div class="row">
                        <input type="text" name="user_id" value="<?php echo htmlspecialchars($user['id']); ?>" hidden>
                        <div class="form-group col-12 col-md-6">
                            <label for="driver_name">Driver Name</label>
                            <input type="text" class="form-control" name="driver_name" id="driver_name" value="<?php echo htmlspecialchars($user['driver_name']); ?>" readonly required>
                        </div>
                        <div class="form-group col-12 col-md-6">
                            <label for="phone">Phone</label>
                            <input type="text" class="form-control" name="phone" id="phone" value="<?php echo htmlspecialchars($user['phone']); ?>" required readonly>
                        </div>
                        <div class="form-group col-12 col-md-6">
                            <label for="driver_email">Email</label>
                            <input type="email" class="form-control" name="driver_email" id="driver_email" value="<?php echo htmlspecialchars($user['driver_email']); ?>" required readonly>
                        </div>
                        <div class="form-group col-12 col-md-6">
                            <label for="vehicle_number">Vehicle Number</label>
                            <input type="text" class="form-control" name="vehicle_number" id="vehicle_number" value="<?php echo htmlspecialchars($user['vehicle_number']); ?>" required readonly>
                        </div>
                        <div class="form-group col-12 col-md-6">
                            <label for="vehicle_type">Vehicle Type</label>
                            <input type="text" class="form-control" name="vehicle_type" id="vehicle_type" value="<?php echo htmlspecialchars($user['vehicle_type']); ?>" required readonly>
                        </div>
                        <div class="form-group col-12 col-md-6">
                            <label for="vehicle_model">Vehicle Model</label>
                            <input type="text" class="form-control" name="vehicle_model" id="vehicle_model" value="<?php echo htmlspecialchars($user['vehicle_model']); ?>" required readonly>
                        </div>
                        <div class="form-group col-12">
                            <label for="driver_address">Driver Address</label>
                            <textarea class="form-control" name="driver_address" id="driver_address" required><?php echo htmlspecialchars($user['driver_address']); ?></textarea>
                        </div>
                        <h6>Update Documents</h6>
                        <hr>
                        <?php
                        displayFileInput($user['license_image'], 'license_image', 'License Image');
                        displayFileInput($user['nic_image_front'], 'nic_image_front', 'NIC Front Image');
                        displayFileInput($user['nic_image_back'], 'nic_image_back', 'NIC Back Image');
                        displayFileInput($user['vehicle_book_image'], 'vehicle_book_image', 'Vehicle Book Image');
                        displayFileInput($user['vehicle_license_image'], 'vehicle_license_image', 'Vehicle License Image');
                        ?>
                        <div class="form-group col-12">
                            <button type="submit" class="btn btn-primary">Save</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Footer -->
    <footer class="footer mt-auto">
        <div class="container">
            <span class="text-muted">© 2024 Driver Dashboard K LIMO || Developed by Lemda (Pvt) Ltd</span>
            <span class="text-muted float-right"><a href="#!" class="text-muted">More Links</a></span>
        </div>
    </footer>

    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.4/dist/umd/popper.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
</body>
</html>
