<?php
header('Access-Control-Allow-Origin: *');
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With, access");
header("Access-Control-Allow-Credentials: true");

require_once 'db.php';

$response = array();

try {
    // Total Drivers
    $result = $conn->query("SELECT COUNT(*) as total_drivers FROM registered_vehicles");
    $row = $result->fetch_assoc();
    $response['totalDrivers'] = $row['total_drivers'];

    // Active Drivers (Assuming 'approval' = 1 means active)
    $result = $conn->query("SELECT COUNT(*) as active_drivers FROM registered_vehicles WHERE approval = 1");
    $row = $result->fetch_assoc();
    $response['activeDrivers'] = $row['active_drivers'];

    // Inactive Drivers
    $response['inactiveDrivers'] = $response['totalDrivers'] - $response['activeDrivers'];

    // Trips Today
    $today = date('Y-m-d');
    $result = $conn->query("SELECT COUNT(*) as trips_today FROM new_trip_booking WHERE DATE(created_at) = '$today'");
    $row = $result->fetch_assoc();
    $response['tripsToday'] = $row['trips_today'];

} catch (Exception $e) {
    $response['error'] = $e->getMessage();
}

echo json_encode($response);
$conn->close();
?>
