<?php
require_once 'db.php';

header('Access-Control-Allow-Origin: *');
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With, access");
header("Access-Control-Allow-Credentials: true");

$method = $_SERVER['REQUEST_METHOD'];
$response = array();

try {
    switch ($method) {
        case 'GET':
            // Fetch all drivers
            $result = $conn->query("SELECT * FROM registered_vehicles");
            $drivers = [];
            while ($row = $result->fetch_assoc()) {
                $drivers[] = $row;
            }
            $response = $drivers;
            break;

        case 'POST':
            // Add a new driver
            $driver_name = $_POST['driver_name'];
            $phone = $_POST['phone'];
            $vehicle_number = $_POST['vehicle_number'];
            $vehicle_type = $_POST['vehicle_type'];
            $vehicle_model = $_POST['vehicle_model'];
            $driver_address = $_POST['driver_address'];
            $driver_email = $_POST['driver_email'];
            $approval = isset($_POST['approval']) && $_POST['approval'] === 'true';

            $license_image = $_FILES['license_image']['name'];
            $nic_image_front = $_FILES['nic_image_front']['name'];
            $nic_image_back = $_FILES['nic_image_back']['name'];
            $vehicle_book_image = $_FILES['vehicle_book_image']['name'];
            $vehicle_license_image = $_FILES['vehicle_license_image']['name'];

            // Upload files
            move_uploaded_file($_FILES['license_image']['tmp_name'], "uploads/$license_image");
            move_uploaded_file($_FILES['nic_image_front']['tmp_name'], "uploads/$nic_image_front");
            move_uploaded_file($_FILES['nic_image_back']['tmp_name'], "uploads/$nic_image_back");
            move_uploaded_file($_FILES['vehicle_book_image']['tmp_name'], "uploads/$vehicle_book_image");
            move_uploaded_file($_FILES['vehicle_license_image']['tmp_name'], "uploads/$vehicle_license_image");

            $stmt = $conn->prepare("INSERT INTO registered_vehicles (driver_name, phone, vehicle_number, vehicle_type, vehicle_model, driver_address, driver_email, approval, license_image, nic_image_front, nic_image_back, vehicle_book_image, vehicle_license_image) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            $stmt->bind_param("sssssssisssss", $driver_name, $phone, $vehicle_number, $vehicle_type, $vehicle_model, $driver_address, $driver_email, $approval, $license_image, $nic_image_front, $nic_image_back, $vehicle_book_image, $vehicle_license_image);
            $stmt->execute();
            $response['message'] = 'Driver added successfully';
            break;

        case 'PUT':
            // Update an existing driver
            $input = file_get_contents("php://input");
            parse_str($input, $_PUT);
            $response[$input];
           

            $id = $_PUT['id'];
            $driver_name = $_PUT['driver_name'];
            $phone = $_PUT['phone'];
            $vehicle_number = $_PUT['vehicle_number'];
            $vehicle_type = $_PUT['vehicle_type'];
            $vehicle_model = $_PUT['vehicle_model'];
            $driver_address = $_PUT['driver_address'];
            $driver_email = $_PUT['driver_email'];
            $approval = isset($_PUT['approval']) && $_PUT['approval'] === 'true';

            $stmt = $conn->prepare("UPDATE registered_vehicles SET driver_name = ?, phone = ?, vehicle_number = ?, vehicle_type = ?, vehicle_model = ?, driver_address = ?, driver_email = ?, approval = ? WHERE id = ?");
            $stmt->bind_param("ssssssssi", $driver_name, $phone, $vehicle_number, $vehicle_type, $vehicle_model, $driver_address, $driver_email, $approval, $id);

            if ($stmt->execute()) {
                if ($stmt->affected_rows > 0) {
                    $response['message'] = 'Driver updated successfully';
                } else {
                    $response['message'] = 'No changes made to the driver';
                }
            } else {
                http_response_code(500);
                $response['error'] = 'Failed to update driver';
            }
            break;

        case 'DELETE':
            // Delete a driver
            $id = $_GET['id'];
            $stmt = $conn->prepare("DELETE FROM registered_vehicles WHERE id = ?");
            $stmt->bind_param("i", $id);
            $stmt->execute();
            $response['message'] = 'Driver deleted successfully';
            break;

        case 'OPTIONS':
            // Handle preflight requests
            http_response_code(204);
            exit();

        default:
            http_response_code(405); // Method Not Allowed
            $response['error'] = 'Method not allowed';
            break;
    }
} catch (Exception $e) {
    http_response_code(500); // Internal Server Error
    $response['error'] = $e->getMessage();
}

echo json_encode($response);
$conn->close();
?>
