<?php
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') { http_response_code(204); exit; }

require __DIR__ . '/db.php';
$action = $_GET['action'] ?? '';

function out($ok=true, $data=null, $message=''){
  echo json_encode(["success"=>$ok, "data"=>$data, "message"=>$message], JSON_UNESCAPED_UNICODE);
  exit;
}
function get_json(){
  $raw = file_get_contents('php://input');
  $json = json_decode($raw, true);
  return is_array($json) ? $json : [];
}

switch($action){

  case 'locations_list': {
    $rows = [];
    $res = $conn->query("SELECT id, name, type, lat, lng FROM locations ORDER BY name");
    while($r = $res->fetch_assoc()){ $rows[] = $r; }
    out(true, $rows);
  }

  case 'stores_list': {
    $vertical = $_GET['vertical'] ?? 'all';
    $location_id = (int)($_GET['location_id'] ?? 0);
    $sql = "SELECT s.id,s.name,s.vertical,s.address,s.phone,s.featured_image,s.rating,l.name AS location_name
            FROM stores s LEFT JOIN locations l ON l.id=s.location_id WHERE s.is_active=1";
    if($vertical !== 'all'){ $vertical = $conn->real_escape_string($vertical); $sql .= " AND s.vertical='{$vertical}'"; }
    if($location_id){ $sql .= " AND s.location_id=".$location_id; }
    $sql .= " ORDER BY s.name";
    $rows=[]; $res=$conn->query($sql); while($r=$res->fetch_assoc()){$rows[]=$r;}
    out(true,$rows);
  }

  case 'store_detail': {
    $id = (int)($_GET['id'] ?? 0);
    $res = $conn->query("SELECT * FROM stores WHERE id={$id} LIMIT 1");
    $row = $res ? $res->fetch_assoc() : null;
    out((bool)$row, $row, $row?'':'Store not found');
  }

  case 'categories_list': {
    $store_id = (int)($_GET['store_id'] ?? 0);
    $rows = [];
    $res = $conn->query("SELECT id, name FROM store_categories WHERE store_id={$store_id} ORDER BY name");
    while($r=$res->fetch_assoc()){$rows[]=$r;}
    out(true,$rows);
  }

  case 'products_by_store': {
    $store_id = (int)($_GET['store_id'] ?? 0);
    $q = trim($_GET['q'] ?? '');
    $sql = "SELECT id, store_id, category_id, name, description, price, image FROM store_products WHERE is_active=1 AND store_id={$store_id}";
    if($q!==''){ $q2 = '%' . $conn->real_escape_string($q) . '%'; $sql .= " AND name LIKE '{$q2}'"; }
    $sql .= " ORDER BY id DESC";
    $rows=[]; $res=$conn->query($sql); while($r=$res->fetch_assoc()){$rows[]=$r;}
    out(true,$rows);
  }

  case 'product_detail': {
    $id = (int)($_GET['id'] ?? 0);
    $res = $conn->query("SELECT id, store_id, category_id, name, description, price, image FROM store_products WHERE id={$id} LIMIT 1");
    $row = $res ? $res->fetch_assoc() : null;
    out((bool)$row, $row, $row?'':'Product not found');
  }

  case 'pharmacy_list': {
    $rows=[]; $res=$conn->query("SELECT id, name, brand, price, image, description FROM pharmacy_items WHERE is_active=1 ORDER BY id DESC");
    while($r=$res->fetch_assoc()){$rows[]=$r;} out(true,$rows);
  }

  case 'maintenance_list': {
    $rows=[]; $res=$conn->query("SELECT id, name, category, base_price, unit, image, description FROM maintenance_services WHERE is_active=1 ORDER BY id DESC");
    while($r=$res->fetch_assoc()){$rows[]=$r;} out(true,$rows);
  }

  case 'create_order': {
    $payload = get_json();
    $customer = $payload['customer'] ?? ["name"=>"","phone"=>"","address"=>""];
    $items = $payload['items'] ?? [];
    if(!$items){ out(false,null,"Cart empty"); }
    $conn->begin_transaction();
    try{
      $code = 'BX' . strtoupper(bin2hex(random_bytes(3)));
      $name = $conn->real_escape_string($customer['name'] ?? '');
      $phone = $conn->real_escape_string($customer['phone'] ?? '');
      $address = $conn->real_escape_string($customer['address'] ?? '');
      $subtotal = 0; foreach($items as $it){ $subtotal += floatval($it['price']) * intval($it['qty']); }
      $delivery_fee = round(max(150.0, $subtotal * 0.05), 2);
      $total = $subtotal + $delivery_fee;
      $conn->query("INSERT INTO orders(order_code,user_name,user_phone,user_address,subtotal,delivery_fee,total,status,created_at)
                    VALUES('{$code}','{$name}','{$phone}','{$address}',{$subtotal},{$delivery_fee},{$total},'pending',NOW())");
      $order_id = $conn->insert_id;
      $stmt = $conn->prepare("INSERT INTO order_items(order_id,product_id,product_name,unit_price,quantity,options_json,line_total) VALUES(?,?,?,?,?,?,?)");
      foreach($items as $it){
        $pid = $conn->real_escape_string($it['id']);
        $pname = $conn->real_escape_string($it['name']);
        $unit = floatval($it['price']); $qty = intval($it['qty']); $opts = json_encode($it['opts']??[]);
        $line = $unit * $qty;
        $stmt->bind_param('iisdiis', $order_id,$pid,$pname,$unit,$qty,$opts,$line);
        $stmt->execute();
      }
      $conn->commit();
      out(true, ["order_id"=>$order_id, "order_code"=>$code], "Order placed");
    } catch(Exception $e){
      $conn->rollback();
      out(false,null,"Order failed");
    }
  }

  case 'taxi_create_booking': {
    $p = get_json();
    $name = $conn->real_escape_string($p['name'] ?? '');
    $phone = $conn->real_escape_string($p['phone'] ?? '');
    $pickup = $conn->real_escape_string($p['pickup'] ?? '');
    $dropoff = $conn->real_escape_string($p['dropoff'] ?? '');
    $vehicle = $conn->real_escape_string($p['vehicle_type'] ?? 'Car');
    $fare = 500.0;
    $conn->query("INSERT INTO taxi_bookings(name,phone,pickup,dropoff,vehicle_type,estimated_fare,status,created_at)
                  VALUES('{$name}','{$phone}','{$pickup}','{$dropoff}','{$vehicle}',{$fare},'new',NOW())");
    $id = $conn->insert_id;
    out(true, ["booking_id"=>$id], "Taxi booking created");
  }

  default: out(true, ["ok"=>1], "API ready");
}
?>
