<?php
// /new_api/stores_search.php
require_once __DIR__ . '/db.php';
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');

$service = isset($_GET['service']) ? strtolower(trim($_GET['service'])) : '';
$city    = isset($_GET['city']) ? trim($_GET['city']) : '';
$lat     = isset($_GET['lat']) ? floatval($_GET['lat']) : null;
$lng     = isset($_GET['lng']) ? floatval($_GET['lng']) : null;
$nearby  = isset($_GET['nearby']) ? intval($_GET['nearby']) : 0;
$radius  = isset($_GET['radius_km']) ? floatval($_GET['radius_km']) : 0; // optional
$limit   = isset($_GET['limit']) ? max(1, min(50, intval($_GET['limit']))) : 20;
$page    = isset($_GET['page']) ? max(1, intval($_GET['page'])) : 1;
$offset  = ($page - 1) * $limit;

$w = ["s.is_active=1"];
$params = [];

if (in_array($service, ['food','grocery','retail'], true)) { $w[]="FIND_IN_SET(?, s.service_types)"; $params[]=$service; }
if ($city !== '') { $w[]="s.city = ?"; $params[]=$city; }

$distanceSql = '';
$order = 's.rating_count DESC, s.rating_avg DESC, s.sponsored_rank ASC';

if ($nearby && $lat !== null && $lng !== null) {
  $distanceSql = " , (6371 * ACOS(LEAST(1,
                   COS(RADIANS(?)) * COS(RADIANS(s.lat)) * COS(RADIANS(s.lng) - RADIANS(?)) +
                   SIN(RADIANS(?)) * SIN(RADIANS(s.lat))
                 ))) AS distance_km ";
  array_unshift($params, $lat, $lng, $lat); // prepend for SELECT order
  $order = 'distance_km ASC, s.sponsored_rank ASC';
}

$where = implode(' AND ', $w);

$sql = "SELECT s.id, s.name, s.description, s.service_types,
               s.rating_avg, s.rating_count, s.min_order, s.delivery_fee,
               s.eta_min, s.eta_max, s.address, s.city, s.lat, s.lng,
               s.logo_url, s.cover_url, s.is_open, s.is_sponsored, s.sponsored_rank
               $distanceSql
        FROM stores s
        WHERE $where";

if ($nearby && $lat !== null && $lng !== null && $radius > 0) {
  $sql .= " HAVING distance_km <= ".floatval($radius)." ";
}

$sql .= " ORDER BY $order
          LIMIT $limit OFFSET $offset";

try {
  $st = $pdo->prepare($sql);
  $st->execute($params);
  $rows = $st->fetchAll();
  echo json_encode(['ok'=>true, 'stores'=>$rows, 'page'=>$page, 'per_page'=>$limit], JSON_UNESCAPED_SLASHES);
} catch (Exception $e) {
  http_response_code(500);
  echo json_encode(['ok'=>false,'error'=>'Query failed']);
}
