<?php
require_once __DIR__.'/../db.php';
$from = trim($_GET['from'] ?? '');
$to   = trim($_GET['to'] ?? '');
$date = trim($_GET['date'] ?? date('Y-m-d'));

$sql = "SELECT t.id, r.from_city, r.to_city, t.trip_date, t.depart_time, t.arrive_time, t.price, t.bus_type, o.name AS operator
        FROM bus_trips t
        JOIN bus_routes r ON r.id=t.route_id
        LEFT JOIN bus_operators o ON o.id=t.operator_id
        WHERE r.from_city LIKE CONCAT('%', ?, '%')
          AND r.to_city LIKE CONCAT('%', ?, '%')
          AND t.trip_date = ?
        ORDER BY t.depart_time ASC";
$stmt = $mysqli->prepare($sql);
$stmt->bind_param('sss', $from, $to, $date);
$stmt->execute();
$res = $stmt->get_result();
$trips = [];
while ($row = $res->fetch_assoc()) $trips[] = $row;
out(['ok'=>true,'trips'=>$trips]);
