<?php // new_api/booking/bus/cities.php
header('Content-Type: application/json');
require_once __DIR__ . '/../../db.php'; // connect $pdo

try {
  $stmt = $pdo->query("
    SELECT DISTINCT from_city AS city FROM bus_routes
    UNION
    SELECT DISTINCT to_city   AS city FROM bus_routes
    ORDER BY city
  ");
  $cities = $stmt->fetchAll(PDO::FETCH_COLUMN);
  echo json_encode(['ok'=>true, 'cities'=>$cities]);
} catch (Throwable $e) {
  http_response_code(500);
  echo json_encode(['ok'=>false, 'error'=>'db']);
}
